public on_PlayerAction(){ 
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("on_PlayerAction",0)
	#endif

	if (!WAR3_check())
		return PLUGIN_CONTINUE

	new sArg[MAX_VAR_LENGTH], sAction[MAX_VAR_LENGTH] 
	new sName[MAX_NAME_LENGTH]  
	new iUserId, id

	read_logargv(0,sArg,MAX_VAR_LENGTH) 
	read_logargv(2,sAction,MAX_VAR_LENGTH) 
	parse_loguser(sArg,sName,MAX_NAME_LENGTH,iUserId) 
	id = find_player("k",iUserId)

	if (!WAR3_CD_installed(id) && iCvar[FT_CD]){
		return PLUGIN_HANDLED
	}


	if(id==0)						// Prevents the server from gaining XP
		return PLUGIN_CONTINUE

#if MOD == 0
	// Bomb planted 
	if (equal(sAction,"Planted_The_Bomb")) {  
		new origin[3]
		new teamname[32]
		new player[32]
		new numplayers
		new targetorigin[3]
		new targetid
		
		get_user_origin(id, origin)
		get_user_team(id, teamname, 31)
		get_players(player, numplayers, "ae", teamname)
		g_bombCarrier = 0	

		new iXP = 3 * xpgiven[p_data[id][P_LEVEL]]												
		
		iXP = XP_give(id, iXP)
					
		if (iCvar[FT_OBJECTIVES]){				
			client_print(id,print_chat, "%L",id,"AWARD_FOR_PLANTING_BOMB",g_MOD,sName,iXP)
		}

		for (new i=0; i<numplayers; ++i){		// Includes self
			targetid=player[i]
			get_user_origin(targetid, targetorigin)
			if (get_distance(origin, targetorigin)<=iCvar[FT_XP_RADIUS]){
				iXP = iCvar[FT_BOMBPLANTERXP] + xpgiven[p_data[targetid][P_LEVEL]]	

				iXP = XP_give(targetid, iXP)

				if (iCvar[FT_OBJECTIVES]){
					get_user_name(targetid,sName,31)					
					client_print(targetid,print_chat, "%L",id,"AWARD_FOR_SUPPORTING_BOMB",g_MOD,sName,iXP)
				}				
			}
		}
	}
   // Bomb defused 
	else if (equal(sAction,"Defused_The_Bomb")) {
		new origin[3]
		new teamname[32]
		new player[32]
		new numplayers
		new targetorigin[3]
		new targetid
		
		get_user_origin(id, origin)
		get_user_team(id, teamname, 31)
		get_players(player, numplayers, "ae", teamname)
		
				
		new iXP = 3 *  xpgiven[p_data[id][P_LEVEL]]											
		
		iXP = XP_give(id, iXP)
				
		if (iCvar[FT_OBJECTIVES]){
			client_print(id,print_chat, "%L",id,"AWARD_FOR_DEFUSING_BOMB",g_MOD,sName,iXP)
		}

		for (new i=0; i<numplayers; ++i){		// Includes self
			targetid=player[i]
			get_user_origin(targetid, targetorigin)
			if (get_distance(origin, targetorigin)<=iCvar[FT_XP_RADIUS]){
				
				iXP = iCvar[FT_DEFUSEXP] +  xpgiven[p_data[targetid][P_LEVEL]]										
				iXP = XP_give(targetid, iXP)
							
				if (iCvar[FT_OBJECTIVES]){
					get_user_name(targetid,sName,31)						
					client_print(targetid,print_chat, "%L",id,"AWARD_FOR_SUPPORT_BOMB_D",g_MOD,sName,iXP)
				}					
			}
		}		
	} 
	// Bomb defusing with a kit 
	else if (equal(sAction,"Begin_Bomb_Defuse_With_Kit")) { 

		if((++p_data[id][P_DEFUSERINDEX] == 1) && (get_user_team(id) == 2) ){  // Team 1 = Terror, Team 2 = CT
			new iXP = iCvar[FT_DEFUSEXP] + xpgiven[p_data[id][P_LEVEL]]

			iXP = XP_give(id, iXP)
				
			if (iCvar[FT_OBJECTIVES]){	
				client_print(id,print_chat, "%L",id,"AWARD_FOR_ATTEMPT_BOMB_D",g_MOD,sName,iXP)
			}
		}               
   } 
   // Bomb defusing without a kit 
	else if (equal(sAction,"Begin_Bomb_Defuse_Without_Kit")) { 
     	
		if( (++p_data[id][P_DEFUSERINDEX] == 1) && (get_user_team(id) == 2) ){  // Team 1 = Terror, Team 2 = CT
			new iXP = xpgiven[p_data[id][P_LEVEL]]

			iXP = XP_give(id, iXP)

			if (iCvar[FT_OBJECTIVES]){
				client_print(id,print_chat, "%L",id,"AWARD_FOR_ATTEMPT_BOMB_D_BARE",g_MOD,id,iXP)
			}
		}
   } 
	// Spawned with the bomb 
	else if (equal(sAction,"Spawned_With_The_Bomb")) { 
		g_bombCarrier = id
	  
		new iXP = xpgiven[p_data[id][P_LEVEL]]											

		iXP = XP_give(id, iXP)

		if (iCvar[FT_OBJECTIVES]){
			client_print(id,print_chat, "%L",id,"AWARD_FOR_SPAWNING_WITH_BOMB",g_MOD,sName,iXP)
		}
	} 

	// Dropped bomb 
	else if (equal(sAction,"Dropped_The_Bomb")) { 
		g_bombCarrier = 0
	  
		new iXP = -1 * xpgiven[p_data[id][P_LEVEL]]											

		iXP = XP_give(id, iXP)

		if (iCvar[FT_OBJECTIVES])
			client_print(id,print_chat, "%L",id,"AWARD_FOR_LOST_BOMB",g_MOD,sName,(-1*iXP))

   } 
	// Picked up bomb 
	else if (equal(sAction,"Got_The_Bomb")) { 
		g_bombCarrier = id
	  
		new iXP = xpgiven[p_data[id][P_LEVEL]]	

		iXP = XP_give(id, iXP)

		if (iCvar[FT_OBJECTIVES])
			client_print(id,print_chat, "%L",id,"AWARD_FOR_PICKING_UP_BOMB",g_MOD,sName,iXP)

	} 
	// Hostage touched 
	else if (equal(sAction,"Touched_A_Hostage")) { 
		new iXP = xpgiven[p_data[id][P_LEVEL]]	

		iXP = XP_give(id, iXP)
				
		if (iCvar[FT_OBJECTIVES])
			client_print(id,print_chat, "%L",id,"AWARD_FOR_BEGINNING_HOSTAGE_RESCUE",g_MOD,sName,iXP)

		g_hostageSaver = id
	} 
	// Hostage rescued 
	else if (equal(sAction,"Rescued_A_Hostage")) { 
		new origin[3]
		new teamname[32]
		new player[32]
		new numplayers
		new targetorigin[3]
		new targetid		
		
		get_user_origin(id, origin)
		get_user_team(id, teamname, 31)
		get_players(player, numplayers, "ae", teamname)
		
		new iXP = xpgiven[p_data[id][P_LEVEL]]												
			
		iXP = XP_give(id, iXP)
				
		if (iCvar[FT_OBJECTIVES])
			client_print(id,print_chat, "%L",id,"AWARD_FOR_RESCUING_HOSTAGE",g_MOD,sName,iXP)

		// Supporters and self	
		for (new i=0; i<numplayers; ++i){
			targetid=player[i]
			get_user_origin(targetid, targetorigin)
			if (get_distance(origin, targetorigin)<=iCvar[FT_XP_RADIUS]){
				iXP = iCvar[FT_HOSTAGEXP] +  xpgiven[p_data[targetid][P_LEVEL]]	

				iXP = XP_give(targetid, iXP)

				if (iCvar[FT_OBJECTIVES]){
					get_user_name(targetid,sName,31)
					client_print(targetid,print_chat, "%L",id,"AWARD_FOR_SUPPORTING_HOSTAGE_RUN",g_MOD,sName,iXP)
				}					
			}				
		}				
   } 

	// Hostage killed 
	else if (equal(sAction,"Killed_A_Hostage")) { 
		new iXP = -1 * xpgiven[p_data[id][P_LEVEL]]

		iXP = XP_give(id, iXP)

		if (iCvar[FT_OBJECTIVES])
			client_print(id,print_chat, "%L",id,"AWARD_FOR_KILLING_HOSTAGE",g_MOD,sName,(-1*iXP))		

	} 
	// VIP spawn 
	else if (equal(sAction,"Became_VIP")) { 
		g_vipID = id
	  
		new iXP = xpgiven[p_data[id][P_LEVEL]]										
		iXP = XP_give(id, iXP)

		if (iCvar[FT_OBJECTIVES]){
			client_print(id,print_chat, "%L",id,"AWARD_FOR_SPAWN_AS_VIP",g_MOD,sName,iXP)
		}
		
	}

	// VIP assassinated 
	else if (equal(sAction,"Assassinated_The_VIP")) { 
		new sNameVIP[MAX_NAME_LENGTH] 
		get_user_name( g_vipID,sNameVIP,MAX_NAME_LENGTH) 		

		new iXP = iCvar[FT_VIP_KILL_BONUS] + xpgiven[p_data[id][P_LEVEL]]	

		iXP = XP_give(id, iXP)

		if (iCvar[FT_OBJECTIVES])
			client_print(id,print_chat, "%L",id,"AWARD_FOR_KILLING_VIP",g_MOD,sName,iXP,sNameVIP) 	
	} 
	// VIP escaped 
	else if (equal(sAction,"Escaped_As_VIP")) { 							
		new origin[3]
		new teamname[32]
		new player[32]
		new numplayers
		new targetorigin[3]
		new targetid

		get_user_origin(id, origin)
		get_user_team(id, teamname, 31)
		get_players(player, numplayers, "ae", teamname)
		
		new iXP = xpgiven[p_data[id][P_LEVEL]]

		iXP = XP_give(id, iXP)

		new nName[31]			
		if (iCvar[FT_OBJECTIVES]){	
			client_print(id,print_chat, "%L",id,"AWARD_FOR_ESCAPED_VIP",g_MOD,sName,iXP)
		}

		for (new i=0; i<numplayers; ++i){		// Includes self
			targetid=player[i]
			get_user_origin(targetid, targetorigin)
			if (get_distance(origin, targetorigin)<=iCvar[FT_XP_RADIUS] && targetid!=id){
				iXP = iCvar[FT_VIP_ESCAPE_BONUS] + xpgiven[p_data[targetid][P_LEVEL]]
					
				iXP = XP_give(targetid, iXP)

				if (iCvar[FT_OBJECTIVES]){
					get_user_name(targetid,nName,31)					
					client_print(targetid,print_chat, "%L",id,"AWARD_FOR_SUPPORTING_VIP",g_MOD,nName,iXP,sName)
				}				
			}
		}
	} 
#endif

	return PLUGIN_HANDLED 
}

#if MOD == 0
	public on_FreezeTimeComplete() {
		#if ADVANCED_DEBUG == 1
			writeDebugInfo("on_FreezeTimeComplete",0)
		#endif

		if (!WAR3_check())
			return PLUGIN_CONTINUE

		g_freezetime = false
		
		new players[32],numberofplayers, id, i, parm[1]
		get_players(players, numberofplayers)
		
		for (i = 0; i < numberofplayers; ++i){
			id=players[i]

			WAR3_Display_Level(id, DISPLAYLEVEL_NONE)
			parm[0]=id
			set_task(0.1,"unholyspeed",TASK_UNHOLYSPEED+id,parm,1)
		}
		return PLUGIN_CONTINUE
	}

	public on_TerroristWin(){
		#if ADVANCED_DEBUG == 1
			writeDebugInfo("T_win",0)
		#endif
		if (warcraft3==false)
			return PLUGIN_CONTINUE

		new players[32], numberofplayers,a, bool:give
		get_players(players,numberofplayers,"e","TERRORIST") 
		for (a = 0; a < numberofplayers; ++a){
			give = true
			if (iCvar[FT_CD]) {
				if (!!WAR3_CD_installed(players[a])){
					give = false
				}
			}
			if(give){
				new iXP = (iCvar[FT_ROUND_WIN_XP] + xpgiven[p_data[players[a]][P_LEVEL]])
				iXP = XP_give(players[a], iXP)
				if (iCvar[FT_OBJECTIVES]){
					new sName[32]
					get_user_name(players[a],sName,31)					
					client_print(players[a],print_chat, "%L",players[a],"AWARD_FOR_WINNING_ROUND",g_MOD,sName,iXP)
				}				
			}
		}
		return PLUGIN_CONTINUE
	}

	public on_CTWin(){
		#if ADVANCED_DEBUG == 1
			writeDebugInfo("CT_win",0)
		#endif
		if (warcraft3==false)
			return PLUGIN_CONTINUE

		new players[32], numberofplayers,a, bool:give
		get_players(players,numberofplayers,"e","CT") 
		for (a = 0; a < numberofplayers; ++a){
			give = true
			if (iCvar[FT_CD]) {
				if (!!WAR3_CD_installed(players[a])){
					give = false
				}
			}
			if(give){
				new iXP = (iCvar[FT_ROUND_WIN_XP] + xpgiven[p_data[players[a]][P_LEVEL]])
				iXP = XP_give(players[a], iXP)

				if (iCvar[FT_OBJECTIVES]){
					new sName[32]
					get_user_name(players[a],sName,31)					
					client_print(players[a],print_chat, "%L",players[a],"AWARD_FOR_WINNING_ROUND",g_MOD,sName,iXP)
				}				
			}
		}
		return PLUGIN_CONTINUE
	}
#endif

// Forwards from the CSX module and DODX module
public grenade_throw(index,greindex,wId){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("grenade_throw",index)
	#endif

	if (!WAR3_check())
		return PLUGIN_CONTINUE

	new szModel[64]
	entity_get_string(greindex, EV_SZ_model, szModel, 63)
#if MOD == 0
	if (greindex && equal(szModel, "models/w_hegrenade.mdl")){
#endif
#if MOD == 1
	if(greindex && (equal(szModel, "models/w_grenade.mdl") || equal(szModel, "models/w_stick.mdl"))){
#endif
		if((p_data[index][0] == 9 && race9Options[2] == 3 && p_data[index][2]) || ( p_data[index][0] == 3 &&  p_data[index][2] )){
			if((p_data[index][P_ITEM2]==ITEM_GLOVES && FT_GLOVE_ORC_DAMAGE) || (p_data[index][P_ITEM2]!=ITEM_GLOVES) && is_user_alive(index)) { 
				Create_TE_BEAMFOLLOW(greindex, g_siTrail, 20, 10, 255, 32, 32, 196)
			} 
		} 
	}
	return PLUGIN_CONTINUE
}

public client_damage(attacker,victim,damage,wpnindex,hitplace,TA){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("damage_dealt",id)
	#endif

	if (!WAR3_check())
		return PLUGIN_CONTINUE

	new enemy = attacker
	new id = victim
	new weapon = wpnindex
	new bodypart = hitplace

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	if(!is_user_connected(enemy))
		return PLUGIN_CONTINUE

	new tempdamage = 0
	if(p_data_b[enemy][PB_MOLE] && (p_data[id][P_ITEM2]==ITEM_PROTECTANT || p_data_b[id][PB_WARDENBLINK])){	
		set_user_health(id,get_user_health(id)+damage)
		client_print(id,print_chat,"%L",id,"SHOT_DEFLECTED",g_MOD)
		return PLUGIN_HANDLED
	}

	if (enemy==id)
		return PLUGIN_HANDLED

	if (enemy==id && weapon==0){
		return PLUGIN_CONTINUE
	}
	else if (enemy==0){
		return PLUGIN_CONTINUE
	}

	if (is_user_bot(enemy) && p_data[enemy][P_ULTIMATE]==1){
		if ((p_data[enemy][P_RACE] == 9 && (race9Options[4] == 3 || race9Options[4] == 4 || race9Options[4] == 5 || race9Options[4] == 6 || race9Options[4] == 8)) || p_data[enemy][P_RACE]==3 || p_data[enemy][P_RACE]==4 || p_data[enemy][P_RACE]==5 || p_data[enemy][P_RACE]==6 || p_data[enemy][P_RACE]==8){
			ultimate(enemy)
		}
	}

	if (((p_data[enemy][P_RACE] == 9 && race9Options[3] == 7) || p_data[enemy][P_RACE] == 7)){	// Shadow Strike
		if (p_data[enemy][P_SKILL3]){
			new Float:randomnumber = random_float(0.0,1.0)
			if (randomnumber <= p_shadow[p_data[enemy][P_SKILL3]-1] && p_data[enemy][P_SHADOWCOUNT]>0 && is_user_alive(id)){
				new idorigin[3], enemyorigin[3]
				get_user_origin(id,idorigin)
				get_user_origin(enemy,enemyorigin)

				Create_TE_SPRITETRAIL(enemyorigin, idorigin, g_sShadow, 50, 15, 1, 2, 6 )
				Create_ScreenFade(id, (1<<10), (1<<10), (1<<12), 0, 255, 0, iglow[id][2])
				emit_sound(id,CHAN_STATIC, SOUND_SHADOWSTRIKE, 1.0, ATTN_NORM, 0, PITCH_NORM)

				p_data[enemy][P_SHADOWCOUNT]--

				tempdamage = 10
				WAR3_damage(id, enemy,tempdamage,CSW_SHADOW, bodypart)
			}
		}
	}
	if (((p_data[enemy][P_RACE] == 9 && race9Options[3] == 8) || p_data[enemy][P_RACE] == 8)){	// Carrion Beetle
		if(p_data[enemy][P_SKILL3]){
			new Float:randomnumber = random_float(0.0,1.0)
			if (randomnumber <= p_carrion[p_data[enemy][P_SKILL3]-1]&& p_data[enemy][P_CARRIONCOUNT]>0 && is_user_alive(id)){
				new idorigin[3], enemyorigin[3]
				get_user_origin(id,idorigin)
				get_user_origin(enemy,enemyorigin)

				Create_TE_SPRITETRAIL(enemyorigin, idorigin, g_sBeetle, 15, 15, 1, 2, 6 )
				emit_sound(id,CHAN_STATIC, SOUND_CARRION, 1.0, ATTN_NORM, 0, PITCH_NORM)

				p_data[enemy][P_CARRIONCOUNT]--

				tempdamage = 10
				WAR3_damage(id, enemy,tempdamage, CSW_CARRION, bodypart)
			}
		}
	}
	if (((p_data[id][P_RACE] == 9 && (race9Options[1] == 4 || race9Options[2] == 4)) || p_data[id][P_RACE] == 4)){		// Elf
		if (((p_data[id][P_RACE] == 9 && race9Options[1] == 4) || p_data[id][P_RACE] == 4) && p_data[id][P_SKILL1]) {		// Evasion
			new healthadjustment = 0
			new bool:p_evadecurrentshot = p_data_b[id][PB_EVADENEXTSHOT]
			new Float:randomnumber = random_float(0.0,1.0)
			if (randomnumber <= p_evasion[p_data[id][P_SKILL1]-1]){
				p_data_b[id][PB_EVADENEXTSHOT]=true
				if (get_user_health(id)<=100){
					healthadjustment = 1024
				}
			}
			else{
				p_data_b[id][PB_EVADENEXTSHOT]=false
				if (get_user_health(id)>100){
					healthadjustment = -1024
				}
			}
			if (p_evadecurrentshot){
				set_user_health(id, get_user_health(id) + damage + healthadjustment)

				if (iglow[id][2] < 1){
					new parm[2]
					parm[0] = id
					set_task(0.01,"glow_change",TASK_GLOW+id,parm,2)
				}
				iglow[id][2] += damage
				iglow[id][0] = 0
				iglow[id][1] = 0
				iglow[id][3] = 0
				if (iglow[id][2]>MAXGLOW)
					iglow[id][2]=MAXGLOW

				Create_ScreenFade(id, (1<<10), (1<<10), (1<<12), 0, 0, 255, iglow[id][2])
			}
			else
				set_user_health(id, get_user_health(id) + healthadjustment)
		}
		if (((p_data[id][P_RACE] == 9 && race9Options[2] == 4) || p_data[id][P_RACE] == 4) && p_data[id][P_SKILL2]) {		// Thorns Aura
			tempdamage = floatround(float(damage) * p_thorns[p_data[id][P_SKILL2]-1])
	
			WAR3_damage(enemy, id,tempdamage,CSW_THORNS, bodypart)

			if (iglow[enemy][0] < 1){
				new parm[2]
				parm[0] = enemy
				set_task(0.01,"glow_change",TASK_GLOW+enemy,parm,2)
			}
			iglow[enemy][0] += 3*tempdamage
			iglow[enemy][1] = 0
			iglow[enemy][2] = 0
			iglow[enemy][3] = 0
			if (iglow[enemy][0]>MAXGLOW)
				iglow[enemy][0]=MAXGLOW

			Create_ScreenFade(enemy, (1<<10), (1<<10), (1<<12), 255, 0, 0, iglow[enemy][0])
		}
	}
	if (((p_data[enemy][P_RACE] == 9 && race9Options[3] == 4) || p_data[enemy][P_RACE] == 4) && p_data[enemy][P_SKILL3]) {		// Trueshot
		tempdamage = floatround(float(damage) * p_trueshot[p_data[enemy][P_SKILL3]-1])

		WAR3_damage(id, enemy,tempdamage,weapon, bodypart)
		if (iglow[id][0] < 1){
			new parm[2]
			parm[0] = id
			set_task(0.01,"glow_change",TASK_GLOW+id,parm,2)
		}
		iglow[id][0] += 2*tempdamage
		iglow[id][1] = 0
		iglow[id][2] = 0
		iglow[id][3] = 0
		if (iglow[id][0]>MAXGLOW)
			iglow[id][0]=MAXGLOW

		Create_ScreenFade(id, (1<<10), (1<<10), (1<<12), 255, 0, 0, iglow[id][0])
	}
	if (((p_data[id][P_RACE] == 9 && race9Options[2] == 8) || p_data[id][P_RACE] == 8)){
		if (p_data[id][P_SKILL2]) {						// Spiked Carapace
			tempdamage = floatround(float(damage) * p_spiked[p_data[id][P_SKILL2]-1])

			WAR3_damage(enemy, id, tempdamage, CSW_CARAPACE, bodypart)

			if(get_user_armor(id)<101)
				set_user_armor(id,get_user_armor(id)+damage)
		
			if (iglow[enemy][0] < 1){
				new parm[2]
				parm[0] = enemy
				set_task(0.01,"glow_change",TASK_GLOW+enemy,parm,2)
			}
			iglow[enemy][0] += 3*tempdamage
			iglow[enemy][1] = 0
			iglow[enemy][2] = 0
			iglow[enemy][3] = 0
			if (iglow[enemy][0]>MAXGLOW)
				iglow[enemy][0]=MAXGLOW

			Create_ScreenFade(enemy, (1<<10), (1<<10), (1<<12), 255, 0, 0, iglow[enemy][0])
		}
	}
	if (p_data[enemy][P_SKILL1] && ((p_data[enemy][P_RACE] == 9 && race9Options[1] == 8) || p_data[enemy][P_RACE] == 8)){
		new Float:randomnumber = random_float(0.0,1.0)
		if (randomnumber <= p_impale[p_data[enemy][P_SKILL1]-1]){
			emit_sound(id,CHAN_STATIC, SOUND_IMPALE, 1.0, ATTN_NORM, 0, PITCH_NORM)
			
			new param[2]
			param[0] = id
			param[1] = 0

			_WAR3_Impale(param)

			Create_ScreenShake(id, (255<< 14), (10 << 14), (255<< 14))
		}
	}
	if (((p_data[enemy][P_RACE] == 9 && race9Options[2] == 6) || p_data[enemy][P_RACE] == 6)){	// Hex
		if (p_data[enemy][P_SKILL2]) {
			new Float:randomnumber = random_float(0.0,1.0)
			if (randomnumber <= p_hex[p_data[enemy][P_SKILL2]-1] && p_data[id][P_SKINCHANGED] != SKIN_HEX){
				changeskin(id,SKIN_HEX)
				new parm[2]
				parm[0]=id
				parm[1]=0
				jumper(parm)

				if (iglow[id][3] < 1){
					parm[0] = id
					parm[1] = 0
					set_task(0.01,"glow_change",TASK_GLOW+id,parm,2)
				}
				iglow[id][3] += 100
				iglow[id][0] = 0
				iglow[id][1] = 0
				iglow[id][2] = 0
				if (iglow[id][3]>MAXGLOW)
					iglow[id][3]=MAXGLOW

				Create_ScreenFade(id, (1<<10), (1<<10), (1<<12), 255, 255, 255, iglow[id][3])
			}
		}
	}
	if (((p_data[enemy][P_RACE] == 9 && (race9Options[2] == 5 || race9Options[3] == 5)) || p_data[enemy][P_RACE] == 5)){	// Banish
		if (((p_data[enemy][P_RACE] == 9 && race9Options[2] == 5) || p_data[enemy][P_RACE] == 5) && p_data[enemy][P_SKILL2]) {
			new Float:randomnumber = random_float(0.0,1.0)
			new num = p_data[enemy][P_SKILL2]-1
			if (randomnumber <= p_banish[num]){

				
				new parm[2]
				parm[0]=id
				if(randomnumber>9){
					user_slap(id,0)
					user_slap(id,0)
					user_slap(id,0)
					WAR3_damage(id, enemy, 9, weapon, bodypart)
				}
				else{
					user_slap(id,0)
					user_slap(id,0)
					user_slap(id,0)
					WAR3_damage(id, enemy, 7, weapon, bodypart)
				}
				emit_sound(enemy,CHAN_STATIC, SOUND_BANISH, 1.0, ATTN_NORM, 0, PITCH_NORM)
				emit_sound(id,CHAN_STATIC, SOUND_BANISH, 1.0, ATTN_NORM, 0, PITCH_NORM)

				if (iglow[id][3] < 1){
					parm[0] = id
					parm[1] = 0
					set_task(0.01,"glow_change",TASK_GLOW+id,parm,2)
				}
				iglow[id][3] += 100
				iglow[id][0] = 0
				iglow[id][1] = 0
				iglow[id][2] = 0
				if (iglow[id][3]>MAXGLOW)
					iglow[id][3]=MAXGLOW

				Create_ScreenFade(id, (1<<10), (1<<10), (1<<12), 255, 255, 255, iglow[id][3])
			}
		}
		if (((p_data[enemy][P_RACE] == 9 && race9Options[3] == 5) || p_data[enemy][P_RACE] == 5) && p_data[enemy][P_SKILL3]) {		// Siphon Mana
			new money = get_user_money(id)
			money = floatround(p_mana[p_data[enemy][P_SKILL3]-1] * money)
			set_user_money(enemy,get_user_money(enemy)+money,1)
			set_user_money(id,get_user_money(id)-money,1)

			if (iglow[enemy][1] < 1){
				new parm[2]
				parm[0] = enemy
				set_task(0.01,"glow_change",TASK_GLOW+enemy,parm,2)
			}
			iglow[enemy][1] += damage
			iglow[enemy][0] = 0
			iglow[enemy][2] = 0
			iglow[enemy][3] = 0
			if (iglow[enemy][1]>MAXGLOW)
				iglow[enemy][1]=MAXGLOW

			Create_ScreenFade(enemy, (1<<10), (1<<10), (1<<12), 120, 120, 120, iglow[enemy][1])
		}
	}
	if (((p_data[enemy][P_RACE] == 9 && race9Options[1] == 1) || p_data[enemy][P_RACE] == 1)){	// Vampiric Aura
		if (p_data[enemy][P_SKILL1]) {
			tempdamage = floatround(float(damage) * p_vampiric[p_data[enemy][P_SKILL1]-1])
			set_user_health(enemy, get_user_health(enemy) + tempdamage)

			if (get_user_health(enemy) > 100 + (p_data[enemy][P_ITEM]==ITEM_HEALTH ? iCvar[FT_HEALTH_BONUS] : 0) ){
				set_user_health(enemy, 100 + (p_data[enemy][P_ITEM]==ITEM_HEALTH ? iCvar[FT_HEALTH_BONUS] : 0) )
			}
			if (iglow[enemy][1] < 1){
				new parm[2]
				parm[0] = enemy
				set_task(0.01,"glow_change",TASK_GLOW+enemy,parm,2)
			}
			iglow[enemy][1] += tempdamage
			iglow[enemy][0] = 0
			iglow[enemy][2] = 0
			iglow[enemy][3] = 0
			if (iglow[enemy][1]>MAXGLOW)
				iglow[enemy][1]=MAXGLOW

			Create_ScreenFade(enemy, (1<<10), (1<<10), (1<<12), 0, 255, 0, iglow[enemy][1])
		}
	}
	if (((p_data[enemy][P_RACE] == 9 && race9Options[3] == 2) || p_data[enemy][P_RACE] == 2)){	// Bash
		if (p_data[enemy][P_SKILL3]) {
			new Float:randomnumber = random_float(0.0,1.0)
			if (randomnumber <= p_bash[p_data[enemy][P_SKILL3]-1] && get_user_maxspeed(id)>5 && !p_data_b[id][PB_SLOWED]){		// Cannot bash if already bashed or frosted
				new normalspeed = floatround(get_user_maxspeed(id))
				set_user_maxspeed(id,1.0)
				p_data_b[id][PB_STUNNED]=true
				new parm[2]
				parm[0]=id
				parm[1]=normalspeed
				set_task(1.0,"reset_maxspeed",TASK_RESETSPEED+id,parm,2)

				if (iglow[id][3] < 1){
					parm[0] = id
					parm[1] = 0
					set_task(0.01,"glow_change",TASK_GLOW+id,parm,2)
				}
				iglow[id][3] += 100
				iglow[id][0] = 0
				iglow[id][1] = 0
				iglow[id][2] = 0
				if (iglow[id][3]>MAXGLOW)
					iglow[id][3]=MAXGLOW

				Create_ScreenFade(id, (1<<10), (1<<10), (1<<12), 255, 255, 255, iglow[id][3])
			}
		}
	}
	if (((p_data[enemy][P_RACE] == 9 && (race9Options[1] == 3 || race9Options[2] == 3)) || p_data[enemy][P_RACE] == 3)){	// Critical Strike
		if (((p_data[enemy][P_RACE] == 9 && race9Options[1] == 3) || p_data[enemy][P_RACE] == 3) && p_data[enemy][P_SKILL1]) {
			new Float:randomnumber = random_float(0.0,1.0)
			if (randomnumber <= p_critical[p_data[enemy][P_SKILL1]-1]){
				tempdamage = floatround(float(damage) * p_data[enemy][P_SKILL1])	// Will be either 1, 2 or 3 times damage induced depending on skill level

				WAR3_damage(id, enemy, tempdamage, weapon, bodypart)
				if (iglow[id][0] < 1){
					new parm[2]
					parm[0] = id
					set_task(0.01,"glow_change",TASK_GLOW+id,parm,2)
				}
				iglow[id][0] += tempdamage
				iglow[id][1] = 0
				iglow[id][2] = 0
				iglow[id][3] = 0
				if (iglow[id][0]>MAXGLOW)
					iglow[id][0]=MAXGLOW

				Create_ScreenFade(id, (1<<10), (1<<10), (1<<12), 255, 0, 0, iglow[id][0])
			}
		}
		if (((p_data[enemy][P_RACE] == 9 && race9Options[2] == 3) || p_data[enemy][P_RACE] == 3) && p_data[enemy][P_SKILL2]){		// Critical Grenade
			new bool:allow=true
			if(p_data[enemy][P_ITEM2]==ITEM_GLOVES){
				if(iCvar[FT_GLOVE_ORC_DAMAGE])
					allow=true
				else
					allow=false
			}
			else
				allow=true
		#if MOD == 0
			if(g_notAllowHE)
				allow=false
			if (weapon == CSW_HEGRENADE && allow){
		#endif
		#if MOD == 1
			if ((weapon == DODW_HANDGRENADE || weapon == DODW_STICKGRENADE) && allow){
		#endif
				tempdamage = floatround(float(damage) * p_grenade[p_data[enemy][P_SKILL2]-1])
				WAR3_damage(id, enemy, tempdamage, weapon, bodypart)
				new name[32]
				get_user_name(id,name,31)
				if (iglow[id][0] < 1){
					new parm[2]
					parm[0] = id
					set_task(0.01,"glow_change",TASK_GLOW+id,parm,2)
				}
				iglow[id][0] += tempdamage
				iglow[id][1] = 0
				iglow[id][2] = 0
				iglow[id][3] = 0
				if (iglow[id][0]>MAXGLOW)
					iglow[id][0]=MAXGLOW

				Create_ScreenFade(id, (1<<10), (1<<10), (1<<12), 255, 0, 0, iglow[id][0])
			}

		}
	}
	if (p_data[enemy][P_ITEM] == ITEM_CLAWS){	// Claws of Attack
		tempdamage = FT_CLAW
		WAR3_damage(id, enemy, tempdamage, weapon, bodypart)
		if (iglow[id][0] < 1){
			new parm[2]
			parm[0] = id
			set_task(0.01,"glow_change",TASK_GLOW+id,parm,2)
		}
		iglow[id][0] += 2*tempdamage
		iglow[id][1] = 0
		iglow[id][2] = 0
		iglow[id][3] = 0
		if (iglow[id][0]>MAXGLOW)

		iglow[id][0]=MAXGLOW

		Create_ScreenFade(id, (1<<10), (1<<10), (1<<12), 255, 0, 0, iglow[id][0])
	}
	else if (p_data[enemy][P_ITEM] == ITEM_MASK){		// Mask of Death
		tempdamage = floatround(float(damage) * FT_MASK_OF_DEATH)
		set_user_health(enemy, get_user_health(enemy) + tempdamage)

		new maxHealth = 100
	
		if(((p_data[enemy][P_RACE] == 9 && race9Options[2] == 2) || p_data[enemy][P_RACE] == 2) && p_devotion[p_data[enemy][P_SKILL2]])
			maxHealth = p_devotion[p_data[enemy][P_SKILL2]-1]

		if (get_user_health(enemy) > maxHealth)
			set_user_health(enemy, maxHealth) 

		if (iglow[enemy][1] < 1){
			new parm[2]
			parm[0] = enemy
			set_task(0.01,"glow_change",TASK_GLOW+enemy,parm,2)
		}
		iglow[enemy][1] += tempdamage
		iglow[enemy][0] = 0
		iglow[enemy][2] = 0
		iglow[enemy][3] = 0
		if (iglow[enemy][1]>MAXGLOW)
			iglow[enemy][1]=MAXGLOW

		Create_ScreenFade(enemy, (1<<10), (1<<10), (1<<12), 0, 255, 0, iglow[enemy][1])
	}
	else if (p_data[enemy][P_ITEM] == ITEM_FROST){	// Frost
		if (get_user_maxspeed(id)>5 && !p_data_b[id][PB_SLOWED]){		// Cannot frost if bashed or frosted
			new normalspeed = floatround(get_user_maxspeed(id))
			set_user_maxspeed(id,fCvar[FT_FROST_SPEED])
			p_data_b[id][PB_SLOWED]=true
			new parm[2]
			parm[0]=id			// Replace "id" with "enemy" to test bash on self
			parm[1]=normalspeed
			set_task(1.0,"reset_maxspeed",TASK_RESETSPEED+id,parm,2)

			if (iglow[id][3] < 1){
				parm[0] = id
				parm[1] = 0
				set_task(0.01,"glow_change",TASK_GLOW+id,parm,2)
			}
			iglow[id][3] += 100
			iglow[id][0] = 0
			iglow[id][1] = 0
			iglow[id][2] = 0
			if (iglow[id][3]>MAXGLOW)
				iglow[id][3]=MAXGLOW

			Create_ScreenFade(id, (1<<10), (1<<10), (1<<12), 255, 255, 255, iglow[id][3])
		}
	}
	return PLUGIN_CONTINUE
} 

public client_death(killer,victim,wpnindex,hitplace,TK){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("client_death",victim)
	#endif

	if (!WAR3_check())
		return PLUGIN_CONTINUE

	if(p_data_b[victim][PB_DIEDLASTROUND])
		return PLUGIN_CONTINUE

	#if MOD == 1
		set_user_money(killer, get_user_money(killer)+300,1)
	#endif

	WAR3_death_victim(victim, killer)


#if MOD == 0
	new headshot = 0

	if(hitplace == 1)
		headshot = 1

	XP_onDeath(victim, killer, wpnindex, headshot)
#endif
#if MOD == 1
	XP_onDeath(victim, killer, wpnindex)
#endif

	return PLUGIN_CONTINUE
}

#if MOD == 0
	public on_ArmorType(id){
		#if ADVANCED_DEBUG == 1
			writeDebugInfo("on_ArmorType",id)
		#endif

		if (!WAR3_check())
			return PLUGIN_CONTINUE

		if (read_data(1))
			p_data_b[id][PB_HELMET]=true
		else
			p_data_b[id][PB_HELMET]=false
		return PLUGIN_CONTINUE
	}

	public on_WeapPickup(id){ 
		#if ADVANCED_DEBUG == 1
			writeDebugInfo("on_WeapPickup",id)
		#endif

		new weapon = read_data(1)
		if (weapon==25)
			++p_data[id][P_FLASHCOUNT]

		if (weapon==CSW_GALIL||weapon==CSW_FAMAS||weapon==CSW_M3||weapon==CSW_XM1014||weapon==CSW_MP5NAVY||weapon==CSW_TMP ||weapon==CSW_P90||weapon==CSW_MAC10||weapon==CSW_UMP45||weapon==CSW_AK47 ||weapon==CSW_SG552||weapon==CSW_M4A1||weapon==CSW_AUG||weapon==CSW_SCOUT ||weapon==CSW_AWP||weapon==CSW_G3SG1||weapon==CSW_SG550||weapon==CSW_M249)
			p_data_b[id][PB_SHIELD]=false

		return PLUGIN_CONTINUE 
	}

	public on_ShowStatus(id){
		#if ADVANCED_DEBUG == 1
			writeDebugInfo("on_ShowStatus",id)
		#endif

		if (g_freezetime){
			Create_StatusText(id, 0, "")
			return PLUGIN_HANDLED
		}

		new pid = read_data(2)

		if(get_user_team(id)==get_user_team(pid) && (p_data[pid][P_ITEM2]==ITEM_CHAMELEON || (p_data[pid][P_SKINCHANGED] == SKIN_HEX || p_data[pid][P_SKINCHANGED]==SKIN_SWITCH)) && is_user_alive(pid)){
			client_print(id,print_center,"%L",id,"HES_ON_YOUR_TEAM_DONT_SHOOT")
			client_cmd(id,"speak warcraft3/antend.wav")
		}

		// Used to show player icons
		if (g_spritesEnabled){
			if (warcraft3 && (get_user_team(id) == get_user_team(pid))){
				if (iCvar[FT_RACE_ICONS] && p_data[id][P_SHOWICONS]){
					Create_TE_PLAYERATTACHMENT(id, pid, 55, g_sRace[p_data[pid][P_RACE]], 15)
				}

				if (iCvar[FT_LEVEL_ICONS] && p_data[id][P_SHOWICONS])
					Create_TE_PLAYERATTACHMENT(id, pid, 35, g_sLevel[p_data[pid][P_LEVEL]], 16)
			}
		}

		return PLUGIN_CONTINUE
	}

	public on_TargetBombed() {
		#if ADVANCED_DEBUG == 1
			writeDebugInfo("on_TargetBombed",0)
		#endif

		/*new players[32]
		new numberofplayers, i
		get_players(players, numberofplayers)
		for (i = 0; i < numberofplayers; ++i){
			client_print(players[i],print_chat,"[%s] Target Bombed...", g_MOD)
		}*/
		return PLUGIN_CONTINUE
	}
#endif


public on_CurWeapon(id) {
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("on_CurWeapon",id)
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE

	if(!is_user_connected(id))
		return PLUGIN_CONTINUE

	if (iCvar[FT_CD]) {
		if (!WAR3_CD_installed(id)){
			return PLUGIN_CONTINUE
		}
	}

	if (p_data[id][P_ITEM2]==ITEM_GLOVES){
		new wpnList[32] = 0 
		new number  = 0
		new foundNade = false 
		get_user_weapons(id,wpnList,number) 
		for (new i = 0;i < number && !foundNade;i++) { 
		#if MOD == 0
			if (wpnList[i] == CSW_HEGRENADE) 
				foundNade = true 
		#endif
		#if MOD == 1
			if (wpnList[i] == DODW_HANDGRENADE || wpnList[i] == DODW_STICKGRENADE) 
				foundNade = true 
		#endif
		}

		new parm[2]
		parm[0]=id
		if(!p_data_b[id][PB_NADEJUSTRECEIVED] && !foundNade)
		{
			p_data_b[id][PB_NADEJUSTRECEIVED]=true
			nadetimer(parm)
		}
	}

	new clipamount = 0
	new ammoamount = 0
	new weaponnum = 0
	weaponnum = (get_user_weapon(id,clipamount,ammoamount))

	#if MOD == 1
		if (weaponnum==DODW_HANDGRENADE || weaponnum==DODW_STICKGRENADE){
			if((p_data[id][P_RACE] == 9 && race9Options[2] == 3 && p_data[id][P_SKILL2])    || ( p_data[id][P_RACE] == 3 &&  p_data[id][P_SKILL2] )){
				dod_set_fuse(id,FUSE_SET,2.0,FT_NEW)


			}
		}

	#endif

	if (((p_data[id][P_RACE] == 9 && race9Options[1] == 2) || p_data[id][P_RACE] == 2) && p_data[id][P_SKILL1]){	// Invisibility
	#if MOD == 0
		if (weaponnum==CSW_KNIFE){
	#endif
	#if MOD == 1
		if (weaponnum==DODW_AMERKNIFE || weaponnum==DODW_GERKNIFE || weaponnum==DODW_SPADE){
	#endif
			set_user_rendering(id,kRenderFxNone, 0,0,0, kRenderTransTexture,p_invisibility[p_data[id][P_SKILL1]-1]/2)
			p_data_b[id][PB_KNIFESELECTED]=true
		}
		else{
			set_user_rendering(id,kRenderFxNone, 0,0,0, kRenderTransTexture,p_invisibility[p_data[id][P_SKILL1]-1])
			p_data_b[id][PB_KNIFESELECTED]=false
		}
	}
	else if (p_data[id][P_ITEM]==ITEM_CLOAK){
	#if MOD == 0
		if (weaponnum==CSW_KNIFE){
	#endif
	#if MOD == 1
		if (weaponnum==DODW_AMERKNIFE || weaponnum==DODW_GERKNIFE || weaponnum==DODW_SPADE){
	#endif
			set_user_rendering(id,kRenderFxNone, 0,0,0, kRenderTransTexture,FT_CLOAK/2)
			p_data_b[id][PB_KNIFESELECTED]=true
		}
		else{
			set_user_rendering(id,kRenderFxNone, 0,0,0, kRenderTransTexture,FT_CLOAK)
			p_data_b[id][PB_KNIFESELECTED]=false
		}
	}
	else
		set_user_rendering(id)

	new parm[1]
	parm[0]=id
	unholyspeed(parm)

	return PLUGIN_CONTINUE
}

public on_EndRound(){
	 #if ADVANCED_DEBUG == 1
		writeDebugInfo("on_EndRound",0)
	#endif
	if (warcraft3==false)
		return PLUGIN_CONTINUE
	endround=true
	g_randomizeCalled = false

	new players[32]
	new numberofplayers
	get_players(players, numberofplayers)
	new y, id

	if(task_exists(TASK_BUYTIME))
		remove_task(TASK_BUYTIME)

	for(y=0;y<33;++y)
		g_spawnPointsUsed[y]=false
		
	for (y = 0; y < numberofplayers; ++y){
		id = players[y]
		if (task_exists(TASK_WAVE+id))					// Removes any current healing processes
			remove_task(TASK_WAVE+id)
		if (task_exists(TASK_ITEM_RINGERATE+id))		// Remove any rings that are regenerating
			remove_task(TASK_ITEM_RINGERATE+id)			
		if (task_exists(TASK_RESETSPEED+id)){			// Remove any reset_maxspeeds occuring (could cause a person to move during freezetime)
			remove_task(TASK_RESETSPEED+id)
			new parm[2]
			parm[0]=id
			reset_maxspeed(parm)
		}

		p_data_b[id][PB_SPAWNEDFROMITEM]=false
		p_data_b[id][PB_PLAYERSPAWNED]=false

		p_data[id][P_CARRIONCOUNT]=2
		p_data[id][P_SHADOWCOUNT]=2
		p_data_b[id][PB_MOLE] = false
		#if MOD == 0
			p_data[id][P_DEFUSERINDEX] = 0
			p_data[id][P_HECOUNT]=0
			p_data[id][P_FLASHCOUNT]=0
		#endif
	}
	#if MOD == 0
		g_freezecalled = 0
		g_buyCalled=false
	#endif
	g_pheonixExistsT=0
	g_pheonixExistsCT=0


	if (iCvar[MP_SAVEXP])
		write_all()

	race9_randomize()
	
	return PLUGIN_CONTINUE
}

public on_ResetHud(id){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("new_round",id)
	#endif

	if (warcraft3==false)
		return PLUGIN_CONTINUE

	if(g_mapDisabled)
		return PLUGIN_CONTINUE

	if (iCvar[FT_CD]) {
		if (!WAR3_CD_installed(id))
			return PLUGIN_CONTINUE
	}

	if(is_user_bot(id)){
		new Float:randomnumber = random_float(0.0,1.0)
		if (randomnumber <= FT_BOT_BUY_ITEM){
			new num = random_num(1,2)
			if (num == 1)
				buy_item(id, random_num(0,8))
			else
				buy_item2(id, random_num(0,8))
		}
	}

	if(p_data[id][P_RACE]==0){
		new parameter[1]
		parameter[0]=id
		set_task(0.3,"getuserinput",TASK_GETINPUT+id,parameter,1)
	}

	if(!g_randomizeCalled){
		race9_randomize()
		g_randomizeCalled = true
	}

	if(p_data_b[id][PB_GAMECOMMENCING]){
		p_data[id][P_ITEM] = 0
		p_data[id][P_ITEM2] = 0
		p_data_b[id][PB_DIEDLASTROUND]=false
		p_data_b[id][PB_GAMECOMMENCING]=false
		#if MOD == 0
			p_data[id][P_HECOUNT] = 0
		#endif
	}
	#if MOD == 0
		if(iCvar[FT_COMPETITIVE] && !g_buyCalled){
			set_task(get_cvar_float("mp_buytime")*60.0,"_WAR3_set_buytime",TASK_BUYTIME)
			g_buyCalled = true
		}
	#endif
	icon_controller(id,ICON_HIDE)

	p_data_b[id][PB_TOBEREVIVED] = false
	p_data_b[id][PB_CHANGINGTEAM] = false

	if (p_data_b[id][PB_PLAYERSPAWNED]){
		if (((p_data[id][P_RACE] == 9 && race9Options[3] == 6) || p_data[id][P_RACE] == 6) && p_data[id][P_SKILL3])			// Serpent Ward
			p_data[id][P_SERPENTCOUNT]=p_serpent[p_data[id][P_SKILL3]-1]
		else
			p_data[id][P_SERPENTCOUNT]=0

		icon_controller(id,ICON_SHOW)

		if(p_data_b[id][PB_STUNNED] || p_data_b[id][PB_SLOWED]){
			p_data_b[id][PB_STUNNED] = false
			p_data_b[id][PB_SLOWED] = false
			new unholyparm[1]
			unholyparm[0]=id
			unholyspeed(unholyparm)
		}

		if(p_data[id][P_ITEM2]!=ITEM_MOLE)
			p_data[id][P_ITEM2]=0

		p_data[id][P_ITEM]=0
		changeskin(id,SKIN_RESET)
		WAR3_Display_Level(id,DISPLAYLEVEL_NONE)
		return PLUGIN_HANDLED
	}

	if (task_exists(TASK_UDELAY+id))		// Stop any cooldowns in effect	
		remove_task(TASK_UDELAY+id)

	if(p_data[id][P_ITEM2]==ITEM_WAND){
		if(clone[id][0]){
			clone_check_dist(id,0)
		}
		if(clone[id][1]){
			clone_check_dist(id,1)
		}
	}

	if (p_data[id][P_RACE] == 9)
		WAR3_Display_Level(id,DISPLAYLEVEL_SHOWRACE)

	if (iCvar[FT_ULTIMATE_DELAY] > 0){
		p_data_b[id][PB_ULTIMATEUSED] = true
		p_data[id][P_ULTIMATEDELAY] = iCvar[FT_ULTIMATE_DELAY]
	}else if(p_data[id][P_ULTIMATE]){
		p_data_b[id][PB_ULTIMATEUSED] = false
	}

	new parm[2]
	parm[0] = id
	if(task_exists(TASK_UDELAY+id))
		remove_task(TASK_UDELAY+id)

	_WAR3_Ultimate_Delay(parm)

	if (p_data[id][P_CHANGERACE]){
		WAR3_set_race(id, p_data[id][P_CHANGERACE])
	}	

	#if MOD == 0
		g_buyTime=true
	#endif

	#if MOD == 0
		if (g_freezecalled==0){
			g_freezetime = true
			g_freezecalled = 1
		}
	#endif

	if (iCvar[FT_WARN_SUICIDE])
		p_data_b[id][PB_SUICIDEATTEMPT] = false

/*	if (p_data[id][P_ITEM2]==ITEM_HELM){
		new helmparm[2]
		helmparm[0] = id
		helmparm[0] = 1
		set_task(5.0,"_Item_Set_Helm",TASK_HELM+id,parm,2)
	}*/

	set_task(0.1, "weapon_controller", TASK_REINCARNATION+id, parm, 2)		// Weapon Reincarnation
	p_data_b[id][PB_ISBURNING] = false
	p_data[id][P_FLAMECOUNT]=0
	endround=false
	p_data_b[id][PB_WARDENBLINK] = false

	#if MOD == 0
		g_hostageSaver = 0
		g_bombDefuser = 0
	#endif
	// Checks skills
	check_skills(id)
	check_fan(id)

	if (p_data_b[id][PB_RESETSKILLS]) {
		p_data[id][P_SKILL1]=0
		p_data[id][P_SKILL2]=0
		p_data[id][P_SKILL3]=0
		p_data[id][P_ULTIMATE]=0
		p_data[id][P_LEVEL] = 0
		p_data_b[id][PB_RESETSKILLS]=false
		WAR3_Display_Level(id,DISPLAYLEVEL_NONE)
	}

	new skillsused = p_data[id][P_SKILL1]+p_data[id][P_SKILL2]+p_data[id][P_SKILL3]+p_data[id][P_ULTIMATE]
	if (skillsused < p_data[id][P_LEVEL]){
		select_skill(id,0)
	}
	return PLUGIN_CONTINUE
}

public on_GameCommencing(){
	#if ADVANCED_DEBUG == 1
		writeDebugInfo("game_commencing",0)
	#endif

	new players[32], numplayers, id
	get_players(players, numplayers)
	for (new i=0; i<numplayers; i++){
		id=players[i]
		p_data_b[id][PB_GAMECOMMENCING]=true
		if(task_exists(TASK_UDELAY+id))
			remove_task(TASK_UDELAY+id)
		
		if(p_data[P_ITEM2][id])
			Item_Set_Helm(id,0)
	}
}
